using System;

public interface IShow
{
  void Show();
}

public class Shape
{
  public int color;
}

public class Point : Shape
{
  public int x;
  public int y;
}

public class Rectangle : Shape, IShow
{
  public int x;
  public int y;
  public int width;
  public int height;
  public void Show()
  {
    Console.WriteLine("Parametry prostokąta:");
    Console.WriteLine("współrzędna x = {0}", x);
    Console.WriteLine("współrzędna y = {0}", y);
    Console.WriteLine("długość = {0}", width);
    Console.WriteLine("szerokość = {0}", height);
  }
}

public class Triangle : Shape, IShow
{
  public Point a;
  public Point b;
  public Point c;
  public void Show()
  {
    Console.WriteLine("Parametry trójkąta:");
    Console.WriteLine("punkt a = ({0}, {1})", a.x, a.y);
    Console.WriteLine("punkt b = ({0}, {1})", b.x, b.y);
    Console.WriteLine("punkt c = ({0}, {1})", c.x, c.y);
  }
}
